/*
 * Decompiled with CFR 0.152.
 */
package com.openlm.userimport.api.soap;

import com.openlm.userimport.User;
import com.openlm.userimport.api.IOpenLMServerAPI;
import com.openlm.userimport.api.xml.Groups;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.datacontract.schemas._2004._07.openlm_server.ObjectFactory;
import org.datacontract.schemas._2004._07.openlm_server.SessionRefresh;
import org.datacontract.schemas._2004._07.openlm_server_services.BaseRequest;
import org.datacontract.schemas._2004._07.openlm_server_services.GroupNamesRequest;
import org.datacontract.schemas._2004._07.openlm_server_services.GroupNamesResponse;
import org.datacontract.schemas._2004._07.openlm_server_services.LoginFormSettingsRequest;
import org.datacontract.schemas._2004._07.openlm_server_services.LoginFormSettingsResponse;
import org.datacontract.schemas._2004._07.openlm_server_services.RequestBaseInfo;
import org.datacontract.schemas._2004._07.openlm_server_services.UserAuthenticationRequest;
import org.datacontract.schemas._2004._07.openlm_server_services.UserAuthenticationResponse;
import org.datacontract.schemas._2004._07.system_collections.ArrayOfKeyValuePairOfintstring;
import org.datacontract.schemas._2004._07.system_collections.KeyValuePairOfintstring;
import services.server.openlm.IAdminAPI;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class WebServiceAPI
implements IOpenLMServerAPI {
    final Supplier<String> sessionIdSupplier;
    IAdminAPI adminApi;
    org.datacontract.schemas._2004._07.openlm_server_services.ObjectFactory servicesFactory = new org.datacontract.schemas._2004._07.openlm_server_services.ObjectFactory();
    ObjectFactory serverFactory = new ObjectFactory();

    public WebServiceAPI(Supplier<String> sessionIdSupplier) {
        this.sessionIdSupplier = sessionIdSupplier;
    }

    @Override
    public String authenticate(String login, String pwd) {
        UserAuthenticationRequest request = this.servicesFactory.createUserAuthenticationRequest();
        request.setPassword(this.servicesFactory.createUserAuthenticationRequestPassword(pwd));
        request.setUserName(this.servicesFactory.createUserAuthenticationRequestUserName(login));
        UserAuthenticationResponse response = this.adminApi.performUserAuthentication(request);
        return (String)response.getSessionID().getValue();
    }

    @Override
    public boolean authRequired() {
        LoginFormSettingsRequest request = this.servicesFactory.createLoginFormSettingsRequest();
        LoginFormSettingsResponse response = this.adminApi.getLoginFormSettings(request);
        return response.isUserAuthenticationRequired();
    }

    @Override
    public Map<String, String> loadGroups() {
        GroupNamesRequest request = this.sessionize(this.servicesFactory.createGroupNamesRequest());
        GroupNamesResponse response = this.adminApi.getGroupsNames(request);
        List<KeyValuePairOfintstring> list = ((ArrayOfKeyValuePairOfintstring)response.getGroups().getValue()).getKeyValuePairOfintstring();
        HashMap<String, String> result = new HashMap<String, String>();
        for (KeyValuePairOfintstring pair : list) {
            result.put(pair.getValue(), String.valueOf(pair.getKey()));
        }
        return result;
    }

    private <T extends BaseRequest> T sessionize(T request) {
        SessionRefresh sessionRefresh = this.serverFactory.createSessionRefresh();
        sessionRefresh.setRefresh(Boolean.FALSE);
        sessionRefresh.setSessionID(this.serverFactory.createSessionRefreshSessionID(this.sessionIdSupplier.get()));
        RequestBaseInfo baseInfo = this.servicesFactory.createRequestBaseInfo();
        baseInfo.setSessionData(this.servicesFactory.createRequestBaseInfoSessionData(sessionRefresh));
        request.setBaseInfo(this.servicesFactory.createBaseRequestBaseInfo(baseInfo));
        return request;
    }

    @Override
    public Map<String, String> loadProjects() {
        GroupNamesRequest request = this.sessionize(this.servicesFactory.createGroupNamesRequest());
        GroupNamesResponse response = this.adminApi.getGroupsNames(request);
        List<KeyValuePairOfintstring> list = ((ArrayOfKeyValuePairOfintstring)response.getGroups().getValue()).getKeyValuePairOfintstring();
        HashMap<String, String> result = new HashMap<String, String>();
        for (KeyValuePairOfintstring pair : list) {
            result.put(pair.getValue(), String.valueOf(pair.getKey()));
        }
        return result;
    }

    @Override
    public void createGroup(String name) {
    }

    @Override
    public String createProject(String name) {
        return null;
    }

    @Override
    public Optional<User> loadUser(String userName) {
        return null;
    }

    @Override
    public void createUser(User user) {
        throw new NotImplementedException();
    }

    @Override
    public void updateUser(User user) {
        throw new NotImplementedException();
    }

    @Override
    public void loadExistingUsers(List<String> userNames) {
        throw new NotImplementedException();
    }

    @Override
    public void updateGroup(String id, String name, String parentId, String prevParentId) {
        throw new NotImplementedException();
    }

    @Override
    public Groups getGroupDetails(String id, String name) {
        throw new NotImplementedException();
    }
}

