/*
 * Decompiled with CFR 0.152.
 */
package com.openlm.userimport.api.xml;

import com.openlm.userimport.User;
import com.openlm.userimport.api.IOpenLMServerAPI;
import com.openlm.userimport.api.xml.AbstractEntity;
import com.openlm.userimport.api.xml.AbstractEntityList;
import com.openlm.userimport.api.xml.Group;
import com.openlm.userimport.api.xml.Groups;
import com.openlm.userimport.api.xml.Message;
import com.openlm.userimport.api.xml.Paging;
import com.openlm.userimport.api.xml.Project;
import com.openlm.userimport.api.xml.ULM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;

public class XmlAPI
implements IOpenLMServerAPI {
    final Supplier<String> sessionIdSupplier;
    final URL url;
    String lastResponse;

    public XmlAPI(String url, Supplier<String> sessionIdSupplier) throws MalformedURLException {
        this.url = new URL(url);
        this.sessionIdSupplier = sessionIdSupplier;
    }

    private ULM send(ULM request, Message.Method ... expected) {
        try {
            boolean ok;
            HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            con.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            ByteArrayOutputStream req = new ByteArrayOutputStream();
            request.printXml(req);
            System.out.println(new String(req.toByteArray()));
            out.write(req.toByteArray());
            out.flush();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy(con.getInputStream(), (OutputStream)baos);
            this.lastResponse = new String(baos.toByteArray());
            System.out.println(this.lastResponse);
            System.out.println();
            ULM result = ULM.parse(new ByteArrayInputStream(baos.toByteArray()));
            if (result.message == null) {
                this.throwUnexpected();
            }
            if (!(ok = this.isMessageExpected(result.message.type, expected))) {
                this.handleError(result);
                this.throwUnexpected();
            }
            return result;
        }
        catch (IOException | JAXBException | ParserConfigurationException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private ULM request(Message.Method method) {
        return new ULM(this.sessionIdSupplier.get(), method);
    }

    private void throwUnexpected() {
        throw new RuntimeException("Unexpected response: " + this.lastResponse);
    }

    private boolean isMessageExpected(Message.Method type, Message.Method[] expected) {
        if (expected != null && expected.length > 0) {
            for (Message.Method method : expected) {
                if (!method.equals((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String authenticate(String login, String pwd) {
        ULM auth = new ULM("0", Message.Method.UserAuthentication);
        auth.name = login;
        auth.pwd = pwd;
        ULM authResponse = this.send(auth, Message.Method.SessionAuthenticationID);
        return authResponse.sessionId;
    }

    @Override
    public boolean authRequired() {
        ULM response = this.send(new ULM("0", Message.Method.GetLoginFormSettings), Message.Method.SkipLoginForm, Message.Method.ShowLoginForm);
        return response.message.type == Message.Method.ShowLoginForm;
    }

    @Override
    public Map<String, String> loadGroups() {
        return this.loadEntities(Message.Method.GetGroupsList, Message.Method.GroupsList, ulm -> ulm.groups);
    }

    @Override
    public Map<String, String> loadProjects() {
        return this.loadEntities(Message.Method.GetProjectsList, Message.Method.ProjectsList, ulm -> ulm.projects);
    }

    private <T extends AbstractEntity> Map<String, String> loadEntities(Message.Method requestMethod, Message.Method expectedResponse, Function<ULM, AbstractEntityList<T>> getter) {
        ULM response = this.send(this.request(requestMethod), expectedResponse);
        return getter.apply((ULM)response).list.stream().filter(AbstractEntity::isEnabled).collect(Collectors.toMap(AbstractEntity::getName, AbstractEntity::getId));
    }

    @Override
    public void createGroup(String name) {
        this.send(this.request(Message.Method.AddGroup2).parameter("group_name", name), Message.Method.Success);
    }

    @Override
    public String createProject(String name) {
        return this.send(this.request(Message.Method.AddProject).parameter("project_name", name), Message.Method.ProjectAdded).parameter("project_id").get();
    }

    @Override
    public Optional<User> loadUser(String userName) {
        ULM request = this.request(Message.Method.GetUserDetails2).parameter("username", userName).parameter("userid", "");
        ULM response = this.send(request, Message.Method.UserDetails, Message.Method.Error);
        if (response.message.type == Message.Method.Error) {
            return Optional.empty();
        }
        return Optional.of(new User(response.parameters.user_name, response.parameters.first_name, response.parameters.last_name, response.parameters.display_name, response.parameters.title, response.parameters.department, response.parameters.phone_number, response.parameters.description, response.parameters.office, response.parameters.email, response.parameters.enabled, this.toIdList(response.groups.list, Group::getId), response.groups.defaultId, this.toIdList(response.projects.list, Project::getId), response.projects.defaultId));
    }

    private <T> List<String> toIdList(List<T> list, Function<T, String> getId) {
        return list.stream().map(getId).collect(Collectors.toList());
    }

    @Override
    public void createUser(User user) {
        this.updateOrCreateUser(user, Message.Method.AddUser2);
    }

    @Override
    public void updateUser(User user) {
        this.updateOrCreateUser(user, Message.Method.UpdateUserDetails2);
    }

    private void updateOrCreateUser(User user, Message.Method method) {
        this.send(this.request(method).parameter("user_name", user.userName).parameter("first_name", user.firstName).parameter("last_name", user.lastName).parameter("display_name", user.displayName).parameter("title", user.title).parameter("department", user.department).parameter("phone_number", user.phoneNumber).parameter("description", user.description).parameter("office", user.office).parameter("email", user.email).parameter("enabled", String.valueOf(user.enabled)).projects(user.defaultProject, user.projects).groups(user.defaultGroup, user.groups), Message.Method.Success);
    }

    @Override
    public void loadExistingUsers(List<String> userNames) {
        ULM request = this.request(Message.Method.GetUsersForPage);
        request.paging = new Paging(0, 30);
        request.showDisabled = Boolean.FALSE;
        this.send(request, Message.Method.UsersList);
    }

    @Override
    public void updateGroup(String id, String name, String parentId, String prevParentId) {
        this.send(this.request(Message.Method.UpdateGroup).parameter("group_id", id).parameter("group_name", name).parameter("group_parent_id", parentId).parameter("group_prev_parent_id", prevParentId), Message.Method.Success);
    }

    @Override
    public Groups getGroupDetails(String id, String name) {
        return this.send((ULM)this.request((Message.Method)Message.Method.GetGroupDetails).parameter((String)"group_id", (String)id).parameter((String)"group_name", (String)name), (Message.Method[])new Message.Method[]{Message.Method.GroupDetails}).parentGroups;
    }

    private void handleError(ULM authResponse) {
        if (authResponse.message.type == Message.Method.Error) {
            throw new RuntimeException(authResponse.message.content.toString());
        }
    }
}

